<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   ptsblockspecialprod
 * @version   2.1.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class PtsBlockSpecialProd extends Module
{
    private $_prefix;
    private $fields_form = array();

    public function __construct()
    {
        $this->name = 'ptsblockspecialprod';
        $this->tab = 'pricing_promotion';
        $this->version = '2.1.0';
        $this->author = 'PrestaBrain';
        $this->need_instance = 0;

        $this->bootstrap = true;
        parent::__construct();
        $this->_prefix = 'ptsprod';

        $this->displayName = $this->l('Pts Special Products Block');
        $this->description = $this->l('Display Special Products in Carousel.');
    }

    public function install()
    {
        $hookspos = array(
            'displayTop',
            'displayHeaderRight',
            'displaySlideshow',
            'topNavigation',
            'displayPromoteTop',
            'displayRightColumn',
            'displayLeftColumn',
            'displayHome',
            'displayFooter',
            'displayBottom',
            'displayContentBottom',
            'displayFootNav',
            'displayFooterTop',
            'displayFooterBottom'
            );
        
        foreach ($hookspos as $hook) {
            if (!Hook::getIdByName($hook)) {
                $new_hook = new Hook();
                $new_hook->name = pSQL($hook);
                $new_hook->title = pSQL($hook);
                $new_hook->add();
            }
        }
        $a = (parent::install() && $this->registerHook('displayHome') && $this->registerHook('header'));
        $this->_clearBLHLCache();
        return $a;
    }

    public function uninstall()
    {
        $this->makeFormConfig();
        $this->deleteConfigs();
        $this->_clearBLHLCache();
        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '<h2>' . $this->displayName . '</h2>';
        if (Tools::isSubmit('submitPtsBlockSpecialProd') && Tools::isSubmit($this->renderName('limit_item'))) {
            $this->makeFormConfig();
            $this->batchUpdateConfigs();
            $this->_clearCache('ptsblockspecialprod.tpl');
            $output .= $this->displayConfirmation($this->l('Settings updated successfully.'));
            $this->_clearBLHLCache();
        }
        return $output . $this->renderForm();
    }

    public function makeFormConfig()
    {
        if ($this->fields_form) {
            return;
        }

        $orders = array(
        0 => array('value' => 'date_add', 'name' => $this->l('Date Add')),
        1 => array('value' => 'date_add DESC', 'name' => $this->l('Date Add DESC')),
        2 => array('value' => 'name', 'name' => $this->l('Name')),
        3 => array('value' => 'name DESC', 'name' => $this->l('Name DESC')),
        4 => array('value' => 'quantity', 'name' => $this->l('Quantity')),
        5 => array('value' => 'quantity DESC', 'name' => $this->l('Quantity DESC')),
        6 => array('value' => 'price', 'name' => $this->l('Price')),
        7 => array('value' => 'price DESC', 'name' => $this->l('Price DESC')));

        $fields = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon' => 'icon-cogs'
                ),

                'input' => array(
                    array(
                        'type'  => 'text',
                        'label' => $this->l('Mod Class'),
                        'name'  => $this->renderName('modclass'),
                        'desc'  => $this->l('Allow emptily.'),
                        'default' => '',
                    ),

                    array(
                        'type'  => 'text',
                        'label' => $this->l('Number of Items In Page'),
                        'name'  => $this->renderName('itemspage'),
                        'desc'  => $this->l('The maximum number of products in each page tab (default: 4).'),
                        'default' => '4',
                    ),

                    array(
                        'type' => 'text',
                        'label' => $this->l('Colums In Tab'),
                        'name' => $this->renderName('columns'),
                        'desc' => $this->l('The maximum number of products in each page tab (default: 4)'),
                        'default' => '4',
                    ),

                    array(
                        'type' => 'text',
                        'label' => $this->l('Limit Items'),
                        'name' => $this->renderName('limit_item'),
                        'desc' => $this->l('The maximum number of products in each Carousel (default: 8).'),
                        'default' => '8',
                    ),

                    array(
                        'type' => 'select',
                        'label' => $this->l('Order By'),
                        'name' => $this->renderName('porder'),
                        'options' => array(
                            'query' => $orders,
                            'id' => 'value',
                            'name' => 'name'
                       ),
                        'default' => 'date_add',
                   )
                ),

                'submit' => array(
                    'title' => $this->l('Save'),
                    'class' => 'btn btn-default')
           ),
        );
        $this->fields_form[] = $fields;
    }

    public function renderForm()
    {
        $this->makeFormConfig();

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table =  $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitPtsBlockSpecialProd';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(($this->fields_form));
    }

    public function getConfigFieldsValues()
    {
        $fields_values = array();

        foreach ($this->fields_form as $f) {
            foreach ($f['form']['input'] as $input) {
                if (isset($input['lang'])) {
                    foreach ($this->languages() as $lang) {
                        $values = Tools::getValue($input['name'].'_'.$lang['id_lang'], (Configuration::hasKey($input['name']) ? Configuration::get($input['name'], $lang['id_lang']) : $input['default']));
                        $fields_values[$input['name']][$lang['id_lang']] = $values;
                    }
                } else {
                    $values = Tools::getValue($input['name'], (Configuration::hasKey($input['name']) ? Configuration::get($input['name']) : $input['default']));
                    $fields_values[$input['name']] = $values;
                }
            }
        }
    
        return $fields_values;
    }

    public function batchUpdateConfigs()
    {
        foreach ($this->fields_form as $f) {
            foreach ($f['form']['input'] as $input) {
                if (isset($input['lang'])) {
                    $data = array();
                    foreach ($this->languages() as $lang) {
                        $val = Tools::getValue($input['name'].'_'.$lang['id_lang'], $input['default']);
                        $data[$lang['id_lang']] = $val;
                    }
                    Configuration::updateValue(trim($input['name']), $data);
                } else { 
                    $val = Tools::getValue($input['name'], $input['default']);
                    Configuration::updateValue($input['name'], $val);
                }
            }
        }
    }

    public function deleteConfigs()
    {
        foreach ($this->fields_form as $f) {
            foreach ($f['form']['input'] as $input) {
                if (isset($input['lang'])) {
                    foreach ($this->languages() as $lang) {
                        Configuration::deleteByName($input['name'].'_'.$lang['id_lang']);
                    }
                } else {
                    Configuration::deleteByName($input['name']);
                }
            }
        }

    }

    public function getConfigValue($key, $value = null)
    {
      return (Configuration::hasKey($this->renderName($key)) ? Configuration::get($this->renderName($key)) : $value);
    }

    public function renderName($name)
    {
        return Tools::strtoupper($this->_prefix.'_'.$name);
    }

    public function languages()
    {
        return Language::getLanguages(false);
    }

    public function hookHeader($params)
    {
        $this->context->controller->addCSS(($this->_path) . 'ptsblockspecialprod.css', 'all');
    }
    public function hookDisplayHome($params)
    {
        return $this->hookRightColumn($params);
    }

    public function hookDisplaySlideshow($params)
    {
        return $this->hookRightColumn($params);
    }

    public function hookDisplayPromoteTop($params)
    {
        return $this->hookRightColumn($params);
    }

    public function hookDisplayBottom($params)
    {
        return $this->hookRightColumn($params);
    }

    public function hookDisplayFooterProduct($params)
    {
        return $this->hookRightColumn($params);
    }

    public function hookDisplayContentBottom($params)
    {
        return $this->hookRightColumn($params);
    }

    public function hookDisplayMassBottom($params)
    {
        return $this->hookRightColumn($params);
    }

    public function hookRightColumn($params)
    {
        if (!$this->isCached('ptsblockspecialprod.tpl', $this->getCacheId()) || _PS_MODE_DEV_) {
            $nb = (int) $this->getConfigValue('limit_item', 8);

            $catids = $this->getConfigValue('catids', '1,2,3');
            $catids = explode(",", $catids);
            $porder = $this->getConfigValue('porder', 'date_add');
            $porder = preg_split("#\s+#", $porder);
            if (!isset($porder[1])) {
                $porder[1] = null;
            }

            $items_page = (int) $this->getConfigValue('itemspage', 4);
            $columns_page = (int) $this->getConfigValue('columns', 4);

            $special = Product::getPricesDrop((int)$params['cookie']->id_lang, 0, $nb, false , $porder[0], $porder[1]);
            
            $dir = dirname(__FILE__) . '/views/templates/hook/products.tpl';
            $oldtdir = _PS_ALL_THEMES_DIR_._THEME_NAME_.'/modules/'.$this->name.'/products.tpl';
            $tdir = _PS_ALL_THEMES_DIR_._THEME_NAME_.'/modules/'.$this->name.'/views/templates/hook/products.tpl';

            if (file_exists($tdir)) {
                $dir = $tdir;
            } elseif (file_exists($oldtdir)) {
                $dir = $oldtdir;
            }

            $this->smarty->assign(array(
                'itemsperpage' => $items_page,
                'columnspage'  => $columns_page,
                'product_tpl'  => $dir,
                'ptsproducts'     => $special,
                'scolumn'      => 12 / $columns_page
            ));
        }
        $this->context->controller->addJS(($this->_path) . 'views/js/ptsblockspecialprod.js');

        return $this->display(__FILE__, 'ptsblockspecialprod.tpl', $this->getCacheId());
    }

    public function hookLeftColumn($params)
    {
        return $this->hookRightColumn($params);
    }

    protected function getCacheId($name = null, $hook = '')
    {
        $cache_array = array(
            $name !== null ? $name : $this->name,
            $hook,
            date('Ymd'),
            (int) Tools::usingSecureMode(),
            (int) $this->context->shop->id,
            (int) Group::getCurrent()->id,
            (int) $this->context->language->id,
            (int) $this->context->currency->id,
            (int) $this->context->country->id
        );
        return implode('|', $cache_array);
    }

    public function _clearBLHLCache()
    {
        $this->_clearCache('ptsblockspecialprod.tpl');
        $this->_clearCache('products.tpl');
    }

    public function hookAddProduct($params)
    {
        $this->_clearBLHLCache();
    }

    public function hookUpdateProduct($params)
    {
        $this->_clearBLHLCache();
    }

    public function hookDeleteProduct($params)
    {
        $this->_clearBLHLCache();
    }
}
