{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<!DOCTYPE HTML>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<!--[if IE 7]><html class="no-js lt-ie9 lt-ie8 ie7"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<!--[if IE 8]><html class="no-js lt-ie9 ie8"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<!--[if gt IE 8]> <html class="no-js ie9"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<html {if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}" {/if} dir="{$LANG_DIRECTION}" class="{$LANG_DIRECTION}">
	<head>
		<meta charset="utf-8" />
		<title>{$meta_title|escape:'html':'UTF-8'}</title>
{if isset($meta_description) AND $meta_description}
		<meta name="description" content="{$meta_description|escape:'html':'UTF-8'}" />
{/if}
{if isset($meta_keywords) AND $meta_keywords}
		<meta name="keywords" content="{$meta_keywords|escape:'html':'UTF-8'}" />
{/if}
		<meta name="generator" content="PrestaShop" />
		<meta name="robots" content="{if isset($nobots)}no{/if}index,{if isset($nofollow) && $nofollow}no{/if}follow" />
		<meta name="viewport" content="width=device-width, minimum-scale=0.25, maximum-scale=1.6, initial-scale=1.0" />
		<meta name="apple-mobile-web-app-capable" content="yes" />
		<link rel="icon" type="image/vnd.microsoft.icon" href="{$favicon_url}?{$img_update_time}" />
		<link rel="shortcut icon" type="image/x-icon" href="{$favicon_url}?{$img_update_time}" />
{if isset($css_files)}
	{foreach from=$css_files key=css_uri item=media}
		{if preg_match("#global#",$css_uri)}
		<link rel="stylesheet" href="{$css_uri|escape:'html':'UTF-8'}"  id="global-style" type="text/css" media="{$media|escape:'html':'UTF-8'}" />
		{else}
			<link rel="stylesheet" href="{$css_uri|escape:'html':'UTF-8'}" type="text/css" media="{$media|escape:'html':'UTF-8'}" />
		{/if}
	{/foreach}
{/if}
{if isset($js_defer) && !$js_defer && isset($js_files) && isset($js_def)}
	{$js_def}
	{foreach from=$js_files item=js_uri}
	<script type="text/javascript" src="{$js_uri|escape:'html':'UTF-8'}"></script>
	{/foreach}
{/if}
		{$HOOK_HEADER}
		<link href='http{if Tools::usingSecureMode()}s{/if}://fonts.googleapis.com/css?family=Merriweather+Sans:300italic,700,300&amp;subset=latin,latin-ext' rel='stylesheet' type='text/css'> 
		<link href='http{if Tools::usingSecureMode()}s{/if}://fonts.googleapis.com/css?family=Lato:400,700,900&amp;subset=latin,latin-ext' rel='stylesheet' type='text/css'>
		<!--[if IE 8]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
	</head>
	<body{if isset($page_name)} id="{$page_name|escape:'html':'UTF-8'}"{/if} class="{if isset($page_name)}{$page_name|escape:'html':'UTF-8'}{/if}{if isset($body_classes) && $body_classes|@count} {implode value=$body_classes separator=' '}{/if}{if $hide_left_column} hide-left-column{/if}{if $hide_right_column} hide-right-column{/if}{if isset($content_only) && $content_only} content_only{/if} lang_{$lang_iso} layout-{$DEFAUTL_LAYOUT}">
	{if !isset($content_only) || !$content_only}
		{if isset($restricted_country_mode) && $restricted_country_mode}
			<div id="restricted-country">
				<p>{l s='You cannot place a new order from your country.'} <span class="bold">{$geolocation_country}</span></p>
			</div>
		{/if}
		<div  class="banner hidden-xs hidden-sm">
			<div class="container">
				{hook h="displayBanner"}
			</div>
		</div>

		<div id="page">
			<header id="header">
				<div id="topbar" class="topbar">
					<div class="container">
						<div class="topbar-left">
							{hook h="displayNav"}
						</div>
					</div>
				</div>
				<div  id="header-main" class="header">
					<div class="container">
						<div class="row">
							<div id="header_logo" class="col-xs-12 col-sm-4 col-md-3">
								<div id="logo-theme" class="logo-store {if Configuration::get('PTS_CP_LOGOTYPE') == 'logo-theme'}logo-theme{/if}">
									<a href="{if $force_ssl}{$base_dir_ssl}{else}{if isset($force_ssl) && $force_ssl}{$base_dir_ssl}{else}{$base_dir}{/if}{/if}" title="{$shop_name|escape:'html':'UTF-8'}">
										<img class="logo img-responsive {if Configuration::get('PTS_CP_LOGOTYPE') == 'logo-theme'}hidden{/if}" src="{$logo_url}" alt="{$shop_name|escape:'html':'UTF-8'}"/>
									</a>
								</div>
							</div>
							<div class="header-right">
								{if isset($HOOK_TOP)}{$HOOK_TOP}{/if}
							</div>
						</div>
					</div>
				</div >
			    <div  id="pts-mainnav" class="main-menu">
				    <div class="container">
					    <div class="row">
						    <div class="pull-right">
							    {if class_exists('PtsthemePanel')}			
									{plugin module='blockcart' hook='displayTop'}				
								{/if}
							</div>
					    	<div class="">
						    	{hook h="displayMainmenu"}
						    </div>
						</div>
					</div>
			    </div>
			</header>
			<!-- hook slideshow -->
			{if $page_name =='index'}
			   <div  id="pts-slideshow" class="slideshow clearfix">
			   		<div class="container-fluid">
			        	{hook h="displayslideshow"}
			        </div>
			    </div>
			{/if}
			{if $page_name =='index'}
				<div id="top_column" class="center_column clearfix">
					<div class="container">
						{hook h="displayTopColumn"}
					</div>
				</div>
			{/if}
			{if $page_name !='index' && $page_name !='pagenotfound'}
				<div id="pts-breadcrumb">
					<div class="container">
						{include file="$tpl_dir./breadcrumb.tpl"}
					</div>
				</div>
			{/if}
			<div id="columns" class="offcanvas-siderbars ">
				<div class="container {if isset($left_column_size) && !empty($left_column_size)}left_null{/if}">
					<div class="row">
						{if isset($left_column_size) && !empty($left_column_size)}
							<div id="left_column" class="sidebar column col-xs-12 col-sm-12 col-md-{$left_column_size|intval} col-md-{$left_column_size|intval}  offcanvas-sidebar">
								{$HOOK_LEFT_COLUMN}
							</div>
						{/if}
						{if isset($left_column_size) && isset($right_column_size)}{assign var='cols' value=(12 - $left_column_size - $right_column_size)}{else}{assign var='cols' value=12}{/if}
							<div id="center_column" class="center_column main-column col-xs-12 col-sm-12 col-md-{$cols|intval}">
		{/if}