<?php
/**
 *  Ps Prestashop SliderShow for Prestashop 1.6.x
 *
 * @package   pssliderlayer
 * @version   3.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 PrestaBrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

if (!defined('_PS_VERSION_'))
	exit;

include_once(_PS_MODULE_DIR_ . 'pssliderlayer/classes/grouplayer.php');
include_once(_PS_MODULE_DIR_ . 'pssliderlayer/classes/sliderlayer.php');
include_once(_PS_MODULE_DIR_ . 'pssliderlayer/classes/status.php');

class PsSliderLayer extends Module {

	private $_html = '';
	private $_currentGroup = array('id_group' => 0, 'title' => '');
	public $groupData = array(
		'id_pssliderlayer_groups' => '',
		'title' => '',
		'id_shop' => '',
		'hook' => '',
		'active' => '',
		'auto_play' => '1',
		'delay' => '9000',
		'fullwidth' => '',
		'width' => '960',
		'height' => '350',
		'md_width' => '12',
		'sm_width' => '12',
		'xs_width' => '12',
		'touch_mobile' => '1',
		'stop_on_hover' => '1',
		'shuffle_mode' => '1',
		'image_cropping' => '0',
		'shadow_type' => '2',
		'show_time_line' => '1',
		'time_line_position' => 'top',
		'background_color' => '#d9d9d9',
		'margin' => '0px 0px 18px',
		'padding' => '5px 5px',
		'background_image' => '0',
		'background_url' => '',
		'navigator_type' => 'none',
		'navigator_arrows' => 'verticalcentered',
		'navigation_style' => 'round',
		'offset_horizontal' => '0',
		'offset_vertical' => '20',
		'show_navigator' => '0',
		'hide_navigator_after' => '200',
		'thumbnail_width' => '100',
		'thumbnail_height' => '50',
		'thumbnail_amount' => '5',
		'group_class' => '',
		'start_with_slide' => '0',
	);
	private $_hookSupport = array(
		'displayTop',
		'displaySlideshow',
		'topNavigation',
		'displayTopColumn',
		'displayLeftColumn',
		'displayHome',
		'displayContentBottom',
		'displayRightColumn',
		'displayBottom',
		'displayFooterTop',
		'displayfooter',
		'displayFooterBottom',
		'displayFootNav',
		'productFooter',
		'displayRightColumnProduct');
	private $_currentSlider = array();
	public $_sliderData = array(
		'transition' => 'random',
		'slot' => 7,
		'rotation' => 0,
		'duration' => 300,
		'delay' => 0,
		'enable_link' => 1,
		'target' => '',
		'start_date_time' => '',
		'end_date_time' => '',
	);
	public $themeName;
	public $img_path;
	public $img_url;
	public $_error_text = '';

	public function __construct() {
		$this->name = 'pssliderlayer';
		$this->tab = 'front_office_features';
		$this->version = '1.0.0';
		$this->author = 'PrestaBrain';
		$this->need_instance = 0;
		$this->secure_key = Tools::encrypt($this->name);
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('Ps Slider Layer for your homepage.');
		$this->description = $this->l('Adds image or text slider to your homepage.');

		$this->themeName = Context::getContext()->shop->getTheme();
		$this->img_path = _PS_MODULE_DIR_ . $this->name . '/views/img/';
		$this->img_url = _MODULE_DIR_ . $this->name . '/views/img/';
	}

	/**
	 * @see Module::install()
	 */
	public function install() {
		// Prepare tab
		$tab = new Tab();
		$tab->active = 1;
		$tab->class_name = 'AdminPsSliderLayer';
		$tab->name = array();
		foreach (Language::getLanguages(true) as $lang)
			$tab->name[$lang['id_lang']] = 'PsSliderLayer';
		$tab->id_parent = -1;
		$tab->module = $this->name;

		/* Adds Module */
		if ($tab->add() && parent::install() && Configuration::updateValue('PSSLIDERLAYER_GROUP_DE', '1')) {
			$res = true;
			$res &= $this->registerHook('header');
			$res &= $this->registerHook('actionShopDataDuplication');
			foreach ($this->_hookSupport as $value)
				$res &= $this->registerHook($value);

			/* Sets up configuration */

			/* Creates tables */
			//$res &= $this->createTables();

			return (bool) $res;
		}
		return false;
	}

	/**
	 * Adds samples
	 */
	private function installSamples() {
		if ($this->checkExistAnyGroup())
			return true;
		//insearch demo for group slider
		$group = new PsSliderGroup();
		$context = Context::getContext();
		//sample for group
		$group->title = 'Sample Group';
		$group->hook = 'displaySlideshow';
		if ($context->shop->id)
			$group->id_shop = $context->shop->id;
		else
			$group->id_shop = $context->tmpOldShop->id;
		$group->active = 1;
		$group->params = PsSliderSlide::base64Encode(Tools::jsonEncode($this->groupData));
		$group->add();

		//sample for slider
		$languages = Language::getLanguages(false);
		for ($i = 1; $i <= 2; ++$i) {
			$slide = new PsSliderSlide();
			$slide->position = $i;
			$slide->active = 1;
			$slide->params = PsSliderSlide::base64Encode(Tools::jsonEncode($this->_sliderData));
			$slide->id_group = $group->id;
			foreach ($languages as $language) {
				$slide->title[$language['id_lang']] = 'Sample slider ' . $i;
				$slide->link[$language['id_lang']] = '';
				$slide->image[$language['id_lang']] = '';
				$slide->thumb[$language['id_lang']] = '';
				$slide->video[$language['id_lang']] = 'a:4:{s:8:"usevideo";s:1:"0";s:7:"videoid";s:0:"";s:9:"videoauto";s:1:"0";s:16:"background_color";s:0:"";}';
				$slide->video[$language['id_lang']] = $this->converParams($slide->video[$language['id_lang']]);
				if ($i == 1)
					$slide->layersparams[$language['id_lang']] = 'a:2:{i:0;a:24:{s:16:"layer_video_type";s:7:"youtube";s:14:"layer_video_id";s:0:"";s:18:"layer_video_height";s:3:"200";s:17:"layer_video_width";s:3:"300";s:17:"layer_video_thumb";s:0:"";s:8:"layer_id";s:3:"1_2";s:13:"layer_content";s:0:"";s:10:"layer_type";s:4:"text";s:11:"layer_class";s:10:"big_orange";s:13:"layer_caption";s:20:"Slider Sample Demo 1";s:15:"layer_font_size";s:5:"100px";s:22:"layer_background_color";s:0:"";s:11:"layer_color";s:0:"";s:10:"layer_link";s:0:"";s:15:"layer_animation";s:4:"fade";s:12:"layer_easing";s:11:"easeOutExpo";s:11:"layer_speed";s:3:"350";s:9:"layer_top";s:2:"68";s:10:"layer_left";s:3:"554";s:13:"layer_endtime";s:1:"0";s:14:"layer_endspeed";s:3:"300";s:18:"layer_endanimation";s:4:"auto";s:15:"layer_endeasing";s:7:"nothing";s:10:"time_start";s:4:"1200";}i:1;a:24:{s:16:"layer_video_type";s:7:"youtube";s:14:"layer_video_id";s:0:"";s:18:"layer_video_height";s:3:"200";s:17:"layer_video_width";s:3:"300";s:17:"layer_video_thumb";s:0:"";s:8:"layer_id";s:3:"1_3";s:13:"layer_content";s:0:"";s:10:"layer_type";s:4:"text";s:11:"layer_class";s:9:"big_black";s:13:"layer_caption";s:19:"Your Caption Here 4";s:15:"layer_font_size";s:5:"100px";s:22:"layer_background_color";s:0:"";s:11:"layer_color";s:0:"";s:10:"layer_link";s:0:"";s:15:"layer_animation";s:4:"fade";s:12:"layer_easing";s:11:"easeOutExpo";s:11:"layer_speed";s:3:"350";s:9:"layer_top";s:3:"140";s:10:"layer_left";s:3:"555";s:13:"layer_endtime";s:1:"0";s:14:"layer_endspeed";s:3:"300";s:18:"layer_endanimation";s:4:"auto";s:15:"layer_endeasing";s:7:"nothing";s:10:"time_start";s:4:"1600";}}';
				else
					$slide->layersparams[$language['id_lang']] = 'a:3:{i:0;a:24:{s:16:"layer_video_type";s:7:"youtube";s:14:"layer_video_id";s:11:"VA770wpLX-Q";s:18:"layer_video_height";s:3:"200";s:17:"layer_video_width";s:3:"300";s:17:"layer_video_thumb";s:48:"http://i1.ytimg.com/vi/VA770wpLX-Q/hqdefault.jpg";s:8:"layer_id";s:3:"1_1";s:13:"layer_content";s:0:"";s:10:"layer_type";s:5:"video";s:11:"layer_class";s:0:"";s:13:"layer_caption";s:17:"Your Video Here 1";s:15:"layer_font_size";s:5:"100px";s:22:"layer_background_color";s:0:"";s:11:"layer_color";s:0:"";s:10:"layer_link";s:0:"";s:15:"layer_animation";s:4:"fade";s:12:"layer_easing";s:11:"easeOutExpo";s:11:"layer_speed";s:3:"350";s:9:"layer_top";s:2:"47";s:10:"layer_left";s:3:"515";s:13:"layer_endtime";s:1:"0";s:14:"layer_endspeed";s:3:"300";s:18:"layer_endanimation";s:4:"auto";s:15:"layer_endeasing";s:7:"nothing";s:10:"time_start";s:3:"400";}i:1;a:24:{s:16:"layer_video_type";s:7:"youtube";s:14:"layer_video_id";s:11:"VA770wpLX-Q";s:18:"layer_video_height";s:3:"200";s:17:"layer_video_width";s:3:"300";s:17:"layer_video_thumb";s:48:"http://i1.ytimg.com/vi/VA770wpLX-Q/hqdefault.jpg";s:8:"layer_id";s:3:"1_2";s:13:"layer_content";s:0:"";s:10:"layer_type";s:4:"text";s:11:"layer_class";s:10:"big_orange";s:13:"layer_caption";s:19:"Your Caption Here 2";s:15:"layer_font_size";s:5:"100px";s:22:"layer_background_color";s:0:"";s:11:"layer_color";s:0:"";s:10:"layer_link";s:0:"";s:15:"layer_animation";s:4:"fade";s:12:"layer_easing";s:11:"easeOutExpo";s:11:"layer_speed";s:3:"350";s:9:"layer_top";s:3:"122";s:10:"layer_left";s:2:"61";s:13:"layer_endtime";s:1:"0";s:14:"layer_endspeed";s:3:"300";s:18:"layer_endanimation";s:4:"auto";s:15:"layer_endeasing";s:7:"nothing";s:10:"time_start";s:3:"800";}i:2;a:24:{s:16:"layer_video_type";s:7:"youtube";s:14:"layer_video_id";s:11:"VA770wpLX-Q";s:18:"layer_video_height";s:3:"200";s:17:"layer_video_width";s:3:"300";s:17:"layer_video_thumb";s:48:"http://i1.ytimg.com/vi/VA770wpLX-Q/hqdefault.jpg";s:8:"layer_id";s:3:"1_3";s:13:"layer_content";s:0:"";s:10:"layer_type";s:4:"text";s:11:"layer_class";s:21:"very_large_black_text";s:13:"layer_caption";s:19:"Your Caption Here 3";s:15:"layer_font_size";s:5:"100px";s:22:"layer_background_color";s:0:"";s:11:"layer_color";s:0:"";s:10:"layer_link";s:0:"";s:15:"layer_animation";s:4:"fade";s:12:"layer_easing";s:11:"easeOutExpo";s:11:"layer_speed";s:3:"350";s:9:"layer_top";s:3:"261";s:10:"layer_left";s:2:"25";s:13:"layer_endtime";s:1:"0";s:14:"layer_endspeed";s:3:"300";s:18:"layer_endanimation";s:4:"auto";s:15:"layer_endeasing";s:7:"nothing";s:10:"time_start";s:4:"1200";}}';
				$slide->layersparams[$language['id_lang']] = $this->converParams($slide->layersparams[$language['id_lang']]);
			}
			$slide->add();
		}
		return true;
	}

	/**
	 * @see Module::uninstall()
	 */
	public function uninstall() {
		$id_tab = (int) Tab::getIdFromClassName('AdminPsSliderLayer');
		if ($id_tab) {
			$tab = new Tab($id_tab);
			$tab->delete();
		}

		/* Deletes Module */
		if (parent::uninstall()) {
			/* Deletes tables */
			$res = $this->deleteTables();
			return $res;
		}
		return false;
	}

	/**
	 * Creates tables
	 */
	protected function createTables() {
		$res = (bool) Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . $this->name . '_groups` (
                `id_' . $this->name . '_groups` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                `title` varchar(255) NOT NULL,    
                `id_shop` int(10) unsigned NOT NULL,
                                `hook` varchar(64) NOT NULL,
                                `active` tinyint(1) unsigned NOT NULL DEFAULT \'1\',
                                `params` text NOT NULL,
                PRIMARY KEY (`id_' . $this->name . '_groups`, `id_shop`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');

		/* Slides configuration */
		$res &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . $this->name . '_slides` (
              `id_' . $this->name . '_slides` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `id_group` int(11) NOT NULL,
              `position` int(10) unsigned NOT NULL DEFAULT \'0\',
              `active` tinyint(1) unsigned NOT NULL DEFAULT \'1\',
                          `params` text NOT NULL,
              PRIMARY KEY (`id_' . $this->name . '_slides`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');

		/* Slides lang configuration */
		$res &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . $this->name . '_slides_lang` (
              `id_' . $this->name . '_slides` int(10) unsigned NOT NULL,
              `id_lang` int(10) unsigned NOT NULL,
              `title` varchar(255) NOT NULL,
              `link` varchar(255) NOT NULL,
              `image` varchar(255) NOT NULL,
              `thumbnail` varchar(255) NOT NULL,
              `video` text,
              `layersparams` text,
              PRIMARY KEY (`id_' . $this->name . '_slides`,`id_lang`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
		$res &= $this->installSamples();
		return $res;
	}

	/**
	 * deletes tables
	 */
	protected function deleteTables() {
		//return true;
		return Db::getInstance()->execute('
          DROP TABLE IF EXISTS `' . _DB_PREFIX_ . $this->name . '_groups`, `' . _DB_PREFIX_ . $this->name . '_slides`, `' . _DB_PREFIX_ . $this->name . '_slides_lang`;
        ');
	}

	public function getContent() {
		$this->_html .= $this->headerHTML();
		if (Tools::isSubmit('importGroup'))
			$this->importGroup();
		if (Tools::getIsset('ptsajax') && Tools::getValue('ptsajax') == 1)
			$this->processAJax();

		if (Tools::getIsset('correctGroup') && Tools::getValue('correctGroup'))
			$this->correctDataGroup();

		if (Tools::getIsset('copylang') && Tools::getValue('copylang'))
			$this->copyLang();

		//action for group
		if (Tools::isSubmit('editgroup') || Tools::isSubmit('submitGroup') || Tools::isSubmit('deletegroup') || Tools::isSubmit('addNewGroup') || Tools::isSubmit('exportgroup') || Tools::isSubmit('changeGStatus')) {
			if (Tools::isSubmit('submitGroup') || Tools::isSubmit('deletegroup') || Tools::isSubmit('changeGStatus')) {
				if ($this->postValidation())
					$this->_postProcess();
			}
			//save group id in config to edit in next time when open module
			if (Tools::isSubmit('submitGroup') || Tools::isSubmit('editgroup') || Tools::isSubmit('changeGStatus'))
				Configuration::updateValue('PSSLIDERLAYER_GROUP_DE', (int) Tools::getValue('id_group'));
			//if (!Tools::isSubmit('addNewGroup'))
			//    $this->genGroupData();
			$this->_html .= $this->renderGroupList();
			$this->_html .= $this->renderGroupConfig();
		}
		elseif (Tools::isSubmit('showsliders') || Tools::isSubmit('submitSlider') || Tools::isSubmit('editSlider') || Tools::isSubmit('deleteSlider') || Tools::isSubmit('addNewSlider') || Tools::isSubmit('changeStatus')) {

			if (Tools::isSubmit('submitSlider') || Tools::isSubmit('deleteSlider') || Tools::isSubmit('changeStatus') || Tools::getValue('duplicateSlider')) {
				if ($this->postValidation())
					$this->_postProcess();
			}
			$this->_html .= $this->renderList();
			$this->_html .= $this->renderConfig();
			$this->_html .= $this->renderSliderForm();
		}
		//action for slideshow
		else {
			//$this->genGroupData();
			$this->_html .= $this->renderGroupList();
			$this->_html .= $this->renderGroupConfig();
		}

		return $this->_html;
	}

	/**
	 * this function is only for developer of prestabrain.com
	 * to correct data for group + slider
	 */
	public function correctDataGroup() {
		$id_group = Tools::getValue('id_group');
		if ($id_group) {
			$group = new PsSliderGroup($id_group);

			if (Validate::isLoadedObject($group)) {
				//correct group data
				$params = Tools::unSerialize($group->params);
				if ($params) {
					$group->params = PsSliderSlide::base64Encode(Tools::jsonEncode($params));
					$group->save();
				}

				//correct slider
				$sliders = $this->getSlides($group->id);
				foreach ($sliders as $slider) {
					$sliderObj = new PsSliderSlide($slider['id_slide']);
					if (Validate::isLoadedObject($sliderObj)) {
						$tmp = Tools::unSerialize($sliderObj->params);
						if ($tmp)
							$sliderObj->params = PsSliderSlide::base64Encode(Tools::jsonEncode($tmp));

						$tmpObj = array();
						foreach ($sliderObj->video as $key => $value) {
							$tmp = Tools::unSerialize($value);
							if ($tmp)
								$tmpObj[$key] = PsSliderSlide::base64Encode(Tools::jsonEncode($tmp));
						}
						if ($tmpObj)
							$sliderObj->video = $tmpObj;

						$tmpObj = array();
						foreach ($sliderObj->layersparams as $key => $value) {
							$tmp = Tools::unSerialize($value);
							if ($tmp)
								$tmpObj[$key] = PsSliderSlide::base64Encode(Tools::jsonEncode($tmp));
						}
						if ($tmpObj)
							$sliderObj->layersparams = $tmpObj;
						//print_r($sliderObj);die;
						$sliderObj->save();
					}
				}
			}
		}
	}

	public function copyLang() {
		$id_group = Tools::getValue('id_group');
		if ($id_group) {
			$sliders = $this->getSlides($id_group);
			$sliderObj = new PsSliderSlide();
			$defined = $sliderObj->getDefinition($sliderObj);
			$defined = $defined['fields'];

			foreach ($sliders as $slider) {
				$sliderObj = new PsSliderSlide($slider['id_slide']);
				if ($sliderObj->id) {
					$langu