<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   ptssocialsidebar
 * @version   1.0.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class PtsSocialSidebar extends Module
{
	private $_prefix;
    private $fields_form = array();

	public function __construct()
    {
        $this->name = 'ptssocialsidebar';
        $this->tab = 'pricing_promotion';
        $this->version = '1.0.0';
        $this->author = 'PrestaBrain';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->_prefix = 'ptssocial';
        $this->displayName = $this->l('Pts Social Sidebar');
        $this->description = $this->l('Display Social Sidebar.');
    }

    public function install()
    {
    	if (!parent::install() || !$this->registerHook('displayFooter') || !$this->registerHook('header')) {
    		return false;
        }
    	return true;
    }

    public function uninstall()
    {
    	if (!parent::uninstall())
    		return false;
        $this->makeFormConfig();
        $this->deleteConfigs();
        
    	return true;
    }

    public function getContent() {
    	$output = '<h2>' . $this->displayName . '</h2>';
    	if (Tools::isSubmit('submitUpdate')) {
    		$this->makeFormConfig();
    		$this->batchUpdateConfigs();
    	}
    	return $output . $this->renderForm();
    }

    public function makeFormConfig()
    {
        $themes = array(
            array('id' => 'transparent', 'name' => $this->l('Transparent')),
            array('id' => 'light', 'name' => $this->l('Light')),
            array('id' => 'gray', 'name' => $this->l('Gray')),
            array('id' => 'drark', 'name' => $this->l('Drark')),
        );
        $fields = array();
    	$fields[0] = array(
        	'form' => array(
        		'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'select',
                        'label' => $this->l('Theme'),
                        'name' => 'theme',
                        'options' => array(
                            'query' => $themes,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'default' => 'transparent',
                    ),
                    
                    array(
                        'type' => 'text',
                        'label' => $this->l('Responsive Max Width'),
                        'name' => 'responsive_maxwidth',
                        'suffix' => 'px',
                        'default' => '979',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Responsive Min Width'),
                        'name' => 'responsive_minwidth',
                        'suffix' => 'px',
                        'default' => '0',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Domain'),
                        'name' => 'domain',
                        'default' => 'mysite.com',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('ID Add This'),
                        'name' => 'idAddthis',
                        'default' => '',
                        'desc' => $this->l('If you not account at').' <a target="_BLANK" href="https://www.addthis.com">Add This</a>, '.
                            $this->l('you can').' <a target="_BLANK" href="https://www.addthis.com/register">'.
                            $this->l('create').'</a> '.$this->l('a account and').' <a target="_BLANK" href="https://www.addthis.com/settings/publisher">'.
                            $this->l('get data-id').' </a>'.$this->l('to input in this param.')
                    ),
            	),
                'submit' => array(
	                'title' => $this->l('Save'),
	                'class' => 'btn btn-default'
                )
        	),
    	);
        $mobile_positions = array(
            array('id' => 'top', 'name' => $this->l('Top')),
            array('id' => 'bottom', 'name' => $this->l('Bottom')),
        );
        $fields[1] = array(
        	'form' => array(
        		'legend' => array(
                    'title' => $this->l('Mobile Config'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'select',
                        'label' => $this->l('Button Bar Position'),
                        'name' => 'mobile_position',
                        'options' => array(
                            'query' => $mobile_positions,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'default' => 'transparent',
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Mobile Theme'),
                        'name' => 'mobile_theme',
                        'options' => array(
                            'query' => $themes,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'default' => 'transparent',
                    ),
                    array(
						'type' => 'switch',
						'label' => $this->l('Status'),
						'name' => 'mobile_status',
						'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                        'default' => '1'
					),
            	),
                'submit' => array(
	                'title' => $this->l('Save'),
	                'class' => 'btn btn-default'
                )
        	),
    	);
        $share_position = array(
            array('id' => 'right', 'name' => $this->l('OutSite Right')),
            array('id' => 'left', 'name' => $this->l('OutSite Left')),
        );
        $share_service = array(
            array('id' => 'facebook', 'name' => $this->l('Facebook')),
            array('id' => 'twitter', 'name' => $this->l('Twitter')),
            array('id' => 'yahoomail', 'name' => $this->l('Y! Mail')),
            array('id' => 'zingme', 'name' => $this->l('ZingMe')),
            array('id' => 'pinterest', 'name' => $this->l('Pinterest Pin It')),
            array('id' => 'more', 'name' => $this->l('More')),
            array('id' => 'print', 'name' => $this->l('Print')),
            array('id' => 'email', 'name' => $this->l('Email')),
            array('id' => 'tumblr', 'name' => $this->l('Tumblr')),
            array('id' => 'linkedin', 'name' => $this->l('LinkedIn')),
            array('id' => 'favorites', 'name' => $this->l('Favorites')),
            array('id' => 'gmail', 'name' => $this->l('Gmail')),
            array('id' => 'google_plusone_share', 'name' => $this->l('Google+ Share')),
            array('id' => 'hotmail', 'name' => $this->l('Hotmail')),
            array('id' => 'linkshares', 'name' => $this->l('LinkShares')),
            array('id' => 'myspace', 'name' => $this->l('Myspace')),
            array('id' => 'printfriendly', 'name' => $this->l('PrintFriendly')),
            array('id' => 'virb', 'name' => $this->l('Virb')),
            array('id' => 'webnews', 'name' => $this->l('Webnews')),
            array('id' => 'windows', 'name' => $this->l('Windows Gadgets')),
            array('id' => 'wordpress', 'name' => $this->l('WordPress')),
            array('id' => 'yigg', 'name' => $this->l('Yigg')),
            array('id' => 'ziczac', 'name' => $this->l('ZicZac')),
        );
        $fields[2] = array(
        	'form' => array(
        		'legend' => array(
                    'title' => $this->l('Share'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'select',
                        'label' => $this->l('Position Share'),
                        'name' => 'share_position',
                        'options' => array(
                            'query' => $share_position,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'default' => 'right',
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Selected Services'),
                        'name' => 'share_service[]',
                        'options' => array(
                            'query' => $share_service,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'multiple' => true,
                        'size' => 15,
                        'default' => 'facebook,twitter,google_plusone_share,email,print,more',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Thank You Title'),
                        'name' => 'share_title',
                        'default' => 'Thanks for sharing!',
                         'lang' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Follow Message'),
                        'name' => 'share_mgs',
                        'default' => 'Follow us',
                         'lang' => true
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Share Theme'),
                        'name' => 'share_theme',
                        'options' => array(
                            'query' => $themes,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'default' => 'transparent',
                    ),
                    array(
						'type' => 'switch',
						'label' => $this->l('Show Desktop'),
						'name' => 'share_desktop',
						'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                        'default' => '1'
					),
                    array(
						'type' => 'switch',
						'label' => $this->l('Show Mobile'),
						'name' => 'share_mobile',
						'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                        'default' => '1'
					),
            	),
                'submit' => array(
	                'title' => $this->l('Save'),
	                'class' => 'btn btn-default'
                )
        	),
    	);
        $fields[3] = array(
        	'form' => array(
        		'legend' => array(
                    'title' => $this->l('Follow'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Title Follow'),
                        'name' => 'follow_title',
                        'default' => 'Follow',
                        'lang' => true
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Theme'),
                        'name' => 'follow_theme',
                        'options' => array(
                            'query' => $themes,
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'default' => 'transparent',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Thank You Title'),
                        'name' => 'follow_thank',
                        'default' => 'Thanks for following!',
                        'lang' => true
                    ),
                    array(
						'type' => 'switch',
						'label' => $this->l('Show Desktop'),
						'name' => 'follow_desktop',
						'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                        'default' => '1'
					),
                    array(
						'type' => 'switch',
						'label' => $this->l('Show Mobile'),
						'name' => 'follow_mobile',
						'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            )
                        ),
                        'default' => '1'
					),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Facebook'),
                        'name' => 'follow_facebook',
                        'default' => '',
                        'prefix' => 'facebook.com/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Twitter'),
                        'name' => 'follow_twitter',
                        'default' => '',
                        'prefix' => 'twitter.com/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Google follow'),
                        'name' => 'follow_google',
                        'default' => '',
                        'prefix' => 'plus.google.com/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Youtube'),
                        'name' => 'follow_youtube',
                        'default' => '',
                        'prefix' => 'youtube.com/user/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Flickr'),
                        'name' => 'follow_flickr',
                        'default' => '',
                        'prefix' => 'flickr.com/photos/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Vimeo'),
                        'name' => 'follow_vimeo',
                        'default' => '',
                        'prefix' => 'vimeo.com/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Pinterest'),
                        'name' => 'follow_pinterest',
                        'default' => '',
                        'prefix' => 'pinterest.com/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Instagram'),
                        'name' => 'follow_instagram',
                        'default' => '',
                        'prefix' => 'instagram.com/',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('LinkedIn'),
                        'name' => 'follow_linkedin',
                        'default' => '',
                        'prefix' => 'linkedin.com/in/',
                    ),
            	),
                'submit' => array(
	                'title' => $this->l('Save'),
	                'class' => 'btn btn-default'
                )
        	),
    	);
		$this->fields_form = $fields;

    }

    public function renderForm()
    {
	 	$this->makeFormConfig();
		$helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table =  $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitUpdate';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
       );

        return $helper->generateForm(($this->fields_form));
    }

    public function getConfigFieldsValues()
    {
    	$languages = Language::getLanguages(false);
    	$fields_values = array();
    	foreach ($this->fields_form as $f) {
    		foreach ($f['form']['input'] as $input) {
    			if (isset($input['lang'])) {
    				foreach ($languages as $lang) {
    					$values = Tools::getValue($input['name'].'_'.$lang['id_lang'], Configuration::get($this->renderName($input['name']), $lang['id_lang']));
                        $fields_values[$input['name']][$lang['id_lang']] = $values ? $values : (Configuration::hasKey($this->renderName($input['name'])) ? $values : $input['default']);
    				}
    			} else {
                    if ($input['name'] == 'share_service[]') {
                        $values = Tools::getValue($input['name'], Configuration::get($this->renderName('share_service')));
                        $fields_values[$input['name']] = $values ? explode(',', $values) : (Configuration::hasKey($this->renderName('share_service')) ? $values : explode(',', $input['default']));
                    } else {
                        $values = Tools::getValue($input['name'], Configuration::get($this->renderName($input['name'])));
                        $fields_values[$input['name']] = $values ? $values : (Configuration::hasKey($this->renderName($input['name'])) ? $values : $input['default']);
                    }
    			}
    		}
    	}
    	return $fields_values;
    }

    public function batchUpdateConfigs()
    {
    	$languages = Language::getLanguages(false);
    	foreach ($this->fields_form as $f) {
    		foreach ($f['form']['input'] as $input) {
    			if (isset($input['lang'])) {
                    $data = array();
    				foreach ($languages as $lang) {
                        $val = Tools::getValue($input['name'].'_'.$lang['id_lang'], Configuration::get($this->renderName($input['name'])).'_'.$lang['id_lang']);
                        $data[$lang['id_lang']] = $val ? $val : $input['default'];
    				}
                    Configuration::updateValue($this->renderName(trim($input['name'])), $data);
    			} else {
                    if ($input['name'] == 'share_service[]') {
                        $val = Tools::getValue('share_service', Configuration::get($this->renderName('share_service')));
                        Configuration::updateValue($this->renderName('share_service'), $val ? implode (',', $val) : $val);
                    } else {
                        $val = Tools::getValue($input['name'], Configuration::get($this->renderName($input['name'])));
                        Configuration::updateValue($this->renderName($input['name']), $val);
                    }
    			}
    		}
    	}
    }

    public function deleteConfigs()
    {
        $languages = Language::getLanguages(false);
        foreach ($this->fields_form as $f) {
            foreach ($f['form']['input'] as $input) {
                if (isset($input['lang'])) {
                    foreach ($languages as $lang) {
                        Configuration::deleteByName($input['name'].'_'.$lang['id_lang']);
                    }
                } else {
                    Configuration::deleteByName($input['name']);
                }
            }
        }
    }

    public function getConfigValue($key, $value=null)
    {
        return(Configuration::hasKey($this->renderName($key))?Configuration::get($this->renderName($key)) : $value);
    }
    
    public function renderName($name)
    {
        return Tools::strtoupper($this->_prefix.'_'.$name);
    }

    public function hookDisplayFooter($params)
    {
        $this->makeFormConfig();
        $configs = $this->getConfigFieldsValues();
        //config follow id services
        $follow_services = array();
        if (!empty($configs['follow_facebook'])) {
            $follow_services[] = array('service' => 'facebook', 'id' => $configs['follow_facebook']);
        }
        if (!empty($configs['follow_twitter'])) {
            $follow_services[] = array('service' => 'twitter', 'id' => $configs['follow_twitter']);
        }
        if (!empty($configs['follow_google'])) {
            $follow_services[] = array('service' => 'google_follow', 'id' => $configs['follow_google']);
        }
        if (!empty($configs['follow_youtube'])) {
            $follow_services[] = array('service' => 'youtube', 'id' => $configs['follow_youtube']);
        }
        if (!empty($configs['follow_flickr'])) {
            $follow_services[] = array('service' => 'flickr', 'id' => $configs['follow_flickr']);
        }
        if (!empty($configs['follow_vimeo'])) {
            $follow_services[] = array('service' => 'vimeo', 'id' => $configs['follow_vimeo']);
        }
        if (!empty($configs['follow_pinterest'])) {
            $follow_services[] = array('service' => 'pinterest', 'id' => $configs['follow_pinterest']);
        }
        if (!empty($configs['follow_instagram'])) {
            $follow_services[] = array('service' => 'instagram', 'id' => $configs['follow_instagram']);
        }
        if (!empty($configs['follow_linkedin'])) {
            $follow_services[] = array('service' => 'linkedin', 'id' => $configs['follow_linkedin']);
        }
        
        $data_services = '';
        if (!empty($configs['share_service[]'])) {
            $data_services = implode(',', $configs['share_service[]']);
        }
        
        $this->smarty->assign(array(
            'social_configs' => $configs,
            'follow_services' => $follow_services,
            'services' => $data_services,
            'share_title' => isset($configs['share_title'][$this->context->language->id]) ? $configs['share_title'][$this->context->language->id] : '',
            'share_mgs' => isset($configs['share_mgs'][$this->context->language->id]) ? $configs['share_mgs'][$this->context->language->id] : '',
            'follow_title' => isset($configs['follow_title'][$this->context->language->id]) ? $configs['follow_title'][$this->context->language->id] : '',
            'follow_thank' => isset($configs['follow_thank'][$this->context->language->id]) ? $configs['follow_thank'][$this->context->language->id] : '',
        ));
        
        return $this->display(__FILE__, 'ptssocialsidebar.tpl');
    }
    
    public function hookHeader($params)
    {
		$js_url = Tools::getShopProtocol().'s7.addthis.com/js/300/addthis_widget.js';
        $idAddthis = $this->getConfigValue('idAddthis');
        if (!empty($idAddthis)) { 
            $js_url .= '#pubid='. $idAddthis;
        }
        $this->context->controller->addJS($js_url);
    }
    
}